<?php
// Include the database connection from db.php
require_once '../config/db.php';

// Get the supplier ID from the query parameter
$supplierId = isset($_GET['id']) ? $_GET['id'] : null;

if ($supplierId) {
    // Fetch supplier information
    $sql = "SELECT * FROM suppliers WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$supplierId]);
    $supplier = $stmt->fetch();

    if (!$supplier) {
        echo "Supplier not found.";
        exit;
    }
} else {
    echo "No supplier ID provided.";
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Supplier Details - Store Management</title>
    <link rel="stylesheet" href="..\libs\bootsrtap\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    
    <style>
        :root {
            --primary-color: #2c3e50;
            --border-color: #dee2e6;
            --text-color: #333333;
            --background-color: #f8f9fa;
        }

        body {
            background-color: var(--background-color);
            font-family: 'Mulish', sans-serif;
            color: var(--text-color);
        }

        .content {
            margin-left: 240px;
            padding: 20px;
        }

        .top-bar {
            background-color: #ffffff;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
            box-shadow: 0 1px 2px rgba(0,0,0,0.1);
        }

        .supplier-card {
            background: white;
            border-radius: 4px;
            box-shadow: 0 1px 2px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }

        .card-header {
            background: var(--primary-color);
            color: white;
            padding: 15px;
        }

        .info-group {
            padding: 15px;
            border-bottom: 1px solid var(--border-color);
        }

        .info-group:last-child {
            border-bottom: none;
        }

        .info-label {
            font-weight: 500;
            color: var(--primary-color);
            margin-bottom: 5px;
        }

        @media (max-width: 768px) {
            .content {
                margin-left: 0;
                padding: 10px;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/side_bar.php'; ?>

    <div class="content">
        <div class="top-bar">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="mb-0">Supplier Details</h4>
                <div>
                    <a href="edit_supplier.php?id=<?= $supplierId ?>" class="btn btn-primary">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="suppliers_list.php" class="btn btn-outline-primary">
                        <i class="fas fa-arrow-left"></i> Back
                    </a>
                </div>
            </div>
        </div>

        <?php if ($supplier): ?>
            <div class="supplier-card">
                <div class="card-header">
                    <h5 class="mb-0">
                        <i class="fas fa-building me-2"></i>
                        <?= htmlspecialchars($supplier['business_name']) ?>
                    </h5>
                </div>
                <div class="card-body">
                    <div class="info-group">
                        <div class="info-label">Contact Person</div>
                        <div><?= htmlspecialchars($supplier['full_name']) ?></div>
                    </div>
                    
                    <div class="info-group">
                        <div class="info-label">Contact Information</div>
                        <div><i class="fas fa-phone me-2"></i><?= htmlspecialchars($supplier['phone_number']) ?></div>
                        <div><i class="fas fa-map-marker-alt me-2"></i><?= htmlspecialchars($supplier['address']) ?></div>
                    </div>
                    
                    <div class="info-group">
                        <div class="info-label">Account Details</div>
                        <div><?= htmlspecialchars($supplier['account_detail']) ?></div>
                    </div>
                    
                    <div class="info-group">
                        <div class="info-label">Additional Information</div>
                        <div><?= htmlspecialchars($supplier['other_info']) ?></div>
                    </div>
                    
                    <div class="info-group">
                        <div class="info-label">Registration Date</div>
                        <div>
                            <i class="far fa-calendar-alt me-2"></i>
                            <?= date('F j, Y', strtotime($supplier['created_at'])) ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Supply History -->
            <div class="supplier-card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-history me-2"></i>Supply History</h5>
                </div>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Total Cost</th>
                                <th>Amount Paid</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Add supply history data here -->
                        </tbody>
                    </table>
                </div>
            </div>
        <?php else: ?>
            <div class="alert alert-warning">
                <i class="fas fa-exclamation-triangle me-2"></i>
                Supplier not found.
            </div>
        <?php endif; ?>
    </div>

    <script src="..\libs\jquery\jquery-3.7.1.min.js"></script>
    <script src="..\libs\bootsrtap\js\bootstrap.bundle.min.js"></script>
</body>
</html>
