<?php
include '../config/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $addQuantity = $_POST['add_quantity'];
    $removeQuantity = $_POST['remove_quantity'];
    $volumeSize = $_POST['volume_size'];
    $volumePrice = $_POST['volume_price'];
    $costPrice = $_POST['cost_price']; // New field for cost price
    $sellingPrice = $_POST['selling_price']; // New field for selling price
    $expirationDate = $_POST['expiration_date']; // Get the new expiration date
    $username = $_SESSION['username']; // Assuming you have the username in the session

    // Ensure values are integers or floats as required
    $addQuantity = (int)$addQuantity;
    $removeQuantity = (int)$removeQuantity;
    $volumeSize = (float)$volumeSize;
    $volumePrice = (float)$volumePrice;
    $costPrice = (float)$costPrice;
    $sellingPrice = (float)$sellingPrice;

    // Fetch current drug details including the drug name
    $stmt = $pdo->prepare("SELECT drug_name, quantity, volume_size, volume_price FROM drugs WHERE id = :id");
    $stmt->execute(['id' => $id]);
    $drug = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($drug) {
        $drugName = $drug['drug_name'];
        $currentQuantity = $drug['quantity'];

        // Check if the quantity to remove is greater than the current quantity
        if ($removeQuantity > $currentQuantity) {
            $_SESSION['error'] = "Cannot remove more than the current quantity available!";
            header("Location: manage_drugs.php");
            exit();
        }

        $newQuantity = $currentQuantity + $addQuantity - $removeQuantity;

        // Update the drug's details including cost price, selling price, and expiration date
        $updateStmt = $pdo->prepare("UPDATE drugs 
                                     SET quantity = :quantity, 
                                         volume_size = :volume_size, 
                                         volume_price = :volume_price, 
                                         cost_price = :cost_price, 
                                         selling_price = :selling_price, 
                                         expiration_date = :expiration_date 
                                     WHERE id = :id");
        $updateStmt->execute([
            'quantity' => $newQuantity,
            'volume_size' => $volumeSize,
            'volume_price' => $volumePrice,
            'cost_price' => $costPrice,
            'selling_price' => $sellingPrice,
            'expiration_date' => $expirationDate, // Bind the expiration date
            'id' => $id
        ]);

        // Insert a record into the transactions table with the drug name
        $activityType = 'Updated Drug';
        $activityDetails = "Updated drug '$drugName': Added $addQuantity, Removed $removeQuantity, New Volume Size: $volumeSize, New Volume Price: $volumePrice, Cost Price: $costPrice, Selling Price: $sellingPrice, Expiration Date: $expirationDate";
        $activityDate = date('Y-m-d H:i:s'); // Current date and time

        $transactionStmt = $pdo->prepare("INSERT INTO transactions (activity_type, activity_details, activity_date, username) 
                                         VALUES (:activity_type, :activity_details, :activity_date, :username)");
        $transactionStmt->execute([
            'activity_type' => $activityType,
            'activity_details' => $activityDetails,
            'activity_date' => $activityDate,
            'username' => $username
        ]);

        $_SESSION['success'] = "Drug updated and transaction recorded successfully!";
    } else {
        $_SESSION['error'] = "Drug not found!";
    }

    header("Location: manage_drugs.php");
    exit();
}
