<?php
session_start();

// Redirect to login page if the user is not an admin
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit();
}
// Include the database connection from db.php
require_once '../config/db.php';

// Fetch all suppliers from the database
$sql = "SELECT id, business_name, full_name, phone_number, created_at FROM suppliers";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$suppliers = $stmt->fetchAll();
include('../includes/side_bar.php');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Suppliers List - Store Management</title>
    <link rel="stylesheet" href="..\libs\bootsrtap\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    
    <style>
        :root {
            --primary-color: #2c3e50;
            --border-color: #dee2e6;
            --text-color: #333333;
            --background-color: #f8f9fa;
        }

        body {
            background-color: var(--background-color);
            font-family: 'Mulish', sans-serif;
            color: var(--text-color);
        }

        .content {
            margin-left: 240px;
            padding: 20px;
        }

        .top-bar {
            background-color: #ffffff;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
            box-shadow: 0 1px 2px rgba(0,0,0,0.1);
        }

        .supplier-card {
            background: white;
            border-radius: 4px;
            box-shadow: 0 1px 2px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }

        .table thead th {
            background-color: var(--primary-color);
            color: white;
        }

        @media (max-width: 768px) {
            .content {
                margin-left: 0;
                padding: 10px;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/side_bar.php'; ?>

    <div class="content">
        <div class="top-bar">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="mb-0">Suppliers List</h4>
                <div>
                    <a href="add_supplier.php" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Add Supplier
                    </a>
                    <a href="admin_dashboard.php" class="btn btn-outline-primary">
                        <i class="fas fa-arrow-left"></i> Back
                    </a>
                </div>
            </div>
        </div>

        <div class="supplier-card">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Business Name</th>
                            <th>Contact Person</th>
                            <th>Phone Number</th>
                            <th>Registration Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($suppliers) > 0): ?>
                            <?php foreach ($suppliers as $supplier): ?>
                                <tr>
                                    <td><?= htmlspecialchars($supplier['id']) ?></td>
                                    <td>
                                        <i class="fas fa-building me-2"></i>
                                        <?= htmlspecialchars($supplier['business_name']) ?>
                                    </td>
                                    <td>
                                        <i class="fas fa-user me-2"></i>
                                        <?= htmlspecialchars($supplier['full_name']) ?>
                                    </td>
                                    <td>
                                        <i class="fas fa-phone me-2"></i>
                                        <?= htmlspecialchars($supplier['phone_number']) ?>
                                    </td>
                                    <td>
                                        <i class="far fa-calendar-alt me-2"></i>
                                        <?= date('M d, Y', strtotime($supplier['created_at'])) ?>
                                    </td>
                                    <td>
                                        <a href="view_supplier.php?id=<?= $supplier['id'] ?>" 
                                           class="btn btn-info btn-sm">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                        <a href="edit_supplier.php?id=<?= $supplier['id'] ?>" 
                                           class="btn btn-warning btn-sm">
                                            <i class="fas fa-edit"></i> Edit
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="text-center py-4">
                                    <i class="fas fa-box-open mb-3 fa-2x text-muted"></i>
                                    <p class="text-muted">No suppliers found</p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script src="..\libs\jquery\jquery-3.7.1.min.js"></script>
    <script src="..\libs\bootsrtap\js\bootstrap.bundle.min.js"></script>
</body>
</html>
